#!/bin/bash

prevSshStatus=0
prevCcmbStatus=0

startTime="$(date -u +%s)"

for var in {1..1000}
do
	nc -z -w 1 192.168.9.2 9000 > /dev/null 2>&1
	ccmbStatus=$?
	nc -z -w 1 192.168.9.2 22 > /dev/null 2>&1
	sshStatus=$?

	# echo "ccmbStatus $ccmbStatus"
	# echo "sshStatus $sshStatus"

	currentTime="$(date -u +%s)"
	elapsed="$(($currentTime-$startTime))"

	# echo "elapsed $elapsed"

	if [ ! $ccmbStatus -eq $prevCcmbStatus ] ; then
		prevCcmbStatus=$ccmbStatus

		if [ $ccmbStatus -eq 0 ] ; then
			echo "CCMB ENABLED after $elapsed s"
		else
			echo "CCMB DISABLED after $elapsed s"
		fi
	fi
	if [ ! $sshStatus -eq $prevSshStatus ] ; then
		prevSshStatus=$sshStatus
		if [ $sshStatus -eq 0 ] ; then
			echo "SSH ENABLED after $elapsed s"
		else
			echo "SSH DISABLED after $elapsed s"
		fi
	fi
	sleep 1
done
